/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.visio;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.visio.VWWizardHelper;
import filenet.vw.toolkit.design.visio.model.mapping.VWMappingItem;
import filenet.vw.toolkit.design.visio.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

class VWMappingTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 4;
    protected static final int COL_STATUS = 0;
    protected static final int COL_VISIO_SHAPE = 1;
    protected static final int COL_SHAPE_TEXT = 2;
    protected static final int COL_DESIGNER_OBJ = 3;
    private VWWizardHelper m_wizardHelper = null;
    private Vector m_rowData = null;

    public VWMappingTableModel(VWWizardHelper wizardHelper) {
        this.m_wizardHelper = wizardHelper;
    }

    public boolean isAllItemsMapped() {
        for (int nIndex = 0; nIndex < this.getRowCount(); ++nIndex) {
            VWMappingItem rowItem = this.getTableItemAt(nIndex);
            if (rowItem == null || rowItem.isMapped()) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyItemsModified() {
        for (int nIndex = 0; nIndex < this.getRowCount(); ++nIndex) {
            VWMappingItem rowItem = this.getTableItemAt(nIndex);
            if (rowItem == null || !rowItem.isModified()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reinitialize(boolean bShowAll) {
        try {
            try {
                if (this.m_rowData == null) {
                    this.m_rowData = new Vector();
                }
                this.m_rowData.removeAllElements();
                VWMappingItem[] rowItems = this.m_wizardHelper.getMappingItems();
                if (rowItems != null) {
                    for (int nIndex = 0; nIndex < rowItems.length; ++nIndex) {
                        if (!bShowAll && (bShowAll || rowItems[nIndex].isMapped())) continue;
                        this.m_rowData.addElement(rowItems[nIndex]);
                    }
                }
                Object var5_5 = null;
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var5_6 = null;
                this.fireTableDataChanged();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fireTableDataChanged();
            throw throwable;
        }
        this.fireTableDataChanged();
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return Icon.class;
            }
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return VWResource.s_visioShape;
            }
            case 2: {
                return VWResource.s_shapeText;
            }
            case 3: {
                return VWResource.s_designerObject;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWMappingItem rowItem = this.getTableItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (rowItem == null) break;
                    return rowItem.getStatusIcon();
                }
                case 1: {
                    if (rowItem == null) break;
                    return rowItem.getVisioShapeDisplayName();
                }
                case 2: {
                    if (rowItem == null) break;
                    return rowItem.getVisioShapeText();
                }
                case 3: {
                    if (rowItem == null) break;
                    return rowItem.getDesignerObjectName();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            if (!this.isCellEditable(nRowIndex, nColumnIndex)) {
                return;
            }
            switch (nColumnIndex) {
                case 0: 
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    this.onUpdateDesignerObjectName(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected VWMappingItem getTableItemAt(int nRowIndex) {
        VWMappingItem rowItem = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            rowItem = (VWMappingItem)this.m_rowData.elementAt(nRowIndex);
        }
        return rowItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateDesignerObjectName(Object aValue, int nRowIndex) {
        block8: {
            block7: {
                try {
                    try {
                        String newValue;
                        if (aValue == null) {
                            Object var6_3 = null;
                            break block7;
                        }
                        VWMappingItem rowItem = this.getTableItemAt(nRowIndex);
                        if (rowItem != null && aValue instanceof String && VWStringUtils.compare(newValue = (String)aValue, rowItem.getDesignerObjectName()) != 0) {
                            rowItem.setDesignerObjectName(newValue);
                            rowItem.setIsModified(true);
                        }
                        break block8;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        Object var6_5 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var6_4 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }
}

